import java.util.ArrayList;

abstract class Visitor
{
  public int visiter( Nombre n )
  {
    return n.getN();
  }

  public int visiter( Plus p )
  {
    ArrayList<Expression> children = p.getChildren();
    int resultat = 0;

    for( Expression e : children )
      resultat += e.accepter( this );

    return resultat;
  }
    
  public abstract int visiter( Moins m );
}

class VisitorClassique extends Visitor
{
  public int visiter( Moins m )
  {
    ArrayList<Expression> children = m.getChildren();
    int resultat = children.get(0).accepter( this );

    for( int i = 1 ; i < children.size() ; ++i )
      resultat -= children.get(i).accepter( this );

    return resultat;
  }  
}

class VisitorBizarre extends Visitor
{
  public int visiter( Moins m )
  {
    ArrayList<Expression> children = m.getChildren();
    int resultat = 0;

    for( Expression e : children )
      resultat += e.accepter( this );

    return -resultat;
  }
}
